Imports System.Attribute

Module CustomAttributes

    <AttributeUsage(AttributeTargets.Class)> _
	Class CustomAttribute
		Inherits System.Attribute

		'Deklaracja dwch prywatnych pl w celu umieszczenia wartoci waciwoci.
		Private msg As String

		'Konstruktor Sub New to jedyny sposb ustawienia waciwoci.
		Public Sub New(ByVal _message As String)
			msg = _message
		End Sub
		Public Overridable ReadOnly Property Message() As String
			Get
				Return msg
		End Property
	End Class

	' Zastosowanie wasnego atrybutu dla tej klasy.
	<Custom("Hello World!")> _
	Class MessageClass
		' Wiadomo
		Private msg As String
		Sub New()
			Dim Attr As Attribute
			Dim CustAttr As CustomAttribute
			Attr = GetCustomAttribute(GetType(MessageClass), _
								GetType(CustomAttribute), False)
			CustAttr = CType(Attr, CustomAttribute)
			If CustAttr Is Nothing Then
				msg = "Nie odnaleziono atrybutu."
			Else
				'Uzyskanie etykiety i wartoci wasnego atrybutu.
				msg = "Etykieta atrybutu to: " & CustAttr.Message
			End If
		End Sub
		Sub Message()
			Console.WriteLine(msg)
		End Sub
	End Class

	Sub Main()
		Dim m As New MessageClass()
		m.Message()
	End Sub

End Module
